﻿/***************************************************************************************************************************

                                        Patient Imaging Functions

***************************************************************************************************************************/


// *************************************************************************************
//      Replace token placeholder with current imaging api token
// *************************************************************************************
var replaceToken = function (registryContext, registryId, url) {

    var promise = $.ajax({
        type: "GET",
        beforeSend: function (request) {
            request.setRequestHeader("__Registry_Context__", registryContext);
            request.setRequestHeader("__Registry_Identifier__", registryId);
        },
        url: '/EFR/API/Token',
        data: "",
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        error: function (e) {
            $("#ImagingStatus").html("<b><i>Imaging Services Not Available</b></i>");
        }
    });

    // Will execute when async call returns
    promise.done(function (data) {
        $("#ImagingStatus").html("<i>Imaging Services Available</i>");
        url = url.replace(/__TTT__/g, data.Result);
        window.open(url, '_blank');
    });
}

// *************************************************************************************
//      Check Imaging Status:
//      (1) Send clear cache indicator
//      (2) Call imaging, get new token and add to cache
// *************************************************************************************
var checkImagingServices = function (registryContext, registryId) {

    var promise = $.ajax({
        type: "GET",
        beforeSend: function (request) {
            request.setRequestHeader("__Registry_Context__", registryContext);
            request.setRequestHeader("__Registry_Identifier__", registryId);
            request.setRequestHeader("__Clear_Cache__", "true");
        },
        url: '/EFR/API/Token',
        data: "",
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        error: function (e) {
            $("#ImagingStatus").html("<b><i>Imaging Services Not Available</b></i>");
        }
    });

    // Will execute when async call returns
    promise.done(function (data) {
        $("#ImagingStatus").html("<i>Imaging Services Available</i>");
    });
}